package net.minecraft.src;


import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.IOException;
import java.util.*;
import java.util.Properties;
import java.io.*;
import java.net.URI;
import java.net.URL;
import net.minecraft.client.Minecraft;

public class mod_ColoredBlocks extends BaseMod
{

    public mod_ColoredBlocks()
    {
        ModLoader.SetInGameHook(this, true, false);
        ModLoader.SetInGUIHook(this, true, false);
        ModLoader.RegisterTileEntity(TileEntityBlockColored.class, "Colored Block");
        ModLoader.AddRecipe(new ItemStack(coloringwand, 1), new Object[] {
            "RDR", "GOG", "BDB", Character.valueOf('R'), new ItemStack(Item.dyePowder, 1, 1), Character.valueOf('G'), new ItemStack(Item.dyePowder, 1, 2), Character.valueOf('B'), new ItemStack(Item.dyePowder, 1, 4), Character.valueOf('O'), Block.obsidian, Character.valueOf('D'), Item.diamond
        });
        importtimer = System.currentTimeMillis();
    }

    public void load()
    {
        
    }

    public String getVersion()
    {
        return "Colored Blocks v1.0.1";
    }

    private static void RegisterNames()
    {
         ModLoader.AddName(coloredblock, "Colored Block");
    }

    public static void RegisterTextures()
    {
        itemindex1 = ModLoader.getUniqueSpriteIndex("/gui/items.png");
        ModLoader.addOverride("/gui/items.png", "/imgz/magicwand.png", itemindex1);
    }

    private static void RegisterBlocks()
    {
        ModLoader.RegisterBlock(coloredblock);
        ModLoader.AddName(coloringwand, "Magic Wand");
    }

    private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            if(!imageDir.exists())
            {
                imageDir.mkdirs();
            }
            if(!propsFile.exists())
            {
                propsFile.getParentFile().mkdirs();
                if(propsFile.createNewFile())
                {
                    CreateProperties();
                } else
                {
                    return;
                }
            }
            if(!propsFile.canRead())
            {
                return;
            }
        }
        catch(Exception exception) { }

        try
        {
            String s = propsFile.getAbsolutePath();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("coloredBlockId");
            coloredblockid = Integer.parseInt(s1.trim());
            s1 = properties.getProperty("importdelay");
            importDelay = Integer.parseInt(s1.trim());
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void CreateProperties()
    {
        try
        {
            FileOutputStream fileoutputstream = new FileOutputStream(propsFile);
            OutputStreamWriter output = new OutputStreamWriter(fileoutputstream, "UTF-8");
            output.write("# Colored Block ID"); output.write('\n');
            output.write("# Default: 211"); output.write('\n');
            output.write("coloredBlockId=211"); output.write('\n');
            output.write('\n');output.write('\n');
            output.write("# Image import delay in miliseconds"); output.write('\n');
            output.write("# This is how long the importer will wait between each block colored."); output.write('\n');
            output.write("importdelay=16"); output.write('\n');
            output.write('\n');
            output.close();
            fileoutputstream.close();
        }
        catch(Exception exception) { }
    }

    public boolean OnTickInGame(float f, Minecraft minecraft)
    {
        if(importInstance != null && System.currentTimeMillis() >= importtimer)
        {
            importtimer = System.currentTimeMillis() + importDelay;
            if(importInstance.importfinished || !importInProgress)
            {
                importInstance = null;
                importing = false;
                importInProgress = false;
            }else
            {
                importInstance.imageTick();
            }
        }
        if(theWorld == null)
        {
            theWorld = mcInst.theWorld;
        }
        return true;
    }

    public boolean OnTickInGUI(float f, Minecraft minecraft, GuiScreen guiscreen)
    {
        if(mcInst.theWorld == null)
        {
            importInstance = null;
            importing = false;
            importInProgress = false;
        }
        return true;
    }

    public static int getxDirection(World world)
    {
        if(xF == xS && yF == yS && zF == zS)
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetFirstSelector(world);
            secondset = false;
            return 0;
        }
        else
        if(xF != xS && yF != yS && zF != zS)
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetSelectors(world);
            return 0;
        }

        if(xF == xS && yF == yS)
        {
            if(zF > zS)
            {
                return 5;
            }
            else
            {
                return 6;
            }
        }
        else
        if(yF == yS && zF == zS)
        {
            if(xF > xS)
            {
                return 3;
            }
            else
            {
                return 4;
            }
        }
        else
        if(xF == xS && zF == zS)
        {
            if(yF > yS)
            {
                return 2;
            }
            else
            {
                return 1;
            }
        }
        else
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetSelectors(world);
            return 0;
        }
    }

    public static int getyDirection(World world)
    {
        if(xF == xT && yF == yT && zF == zT)
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetFirstSelector(world);
            resetSecondSelector(world);
            thirdset = false;
            return 0;
        }else
        if(xS == xT && yS == yT && zS == zT)
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetFirstSelector(world);
            resetSecondSelector(world);
            thirdset = false;
        }
        else if(xF != xT && yF != yT && zF != zT)
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetSelectors(world);
        }

        if(xF == xT && yF == yT)
        {
            if(zF > zT)
            {
                return 5;
            }
            else
            {
                return 6;
            }
        }
        else
        if(yF == yT && zF == zT)
        {
            if(xF > xT)
            {
                return 3;
            }
            else
            {
                return 4;
            }
        }
        else
        if(xF == xT && zF == zT)
        {
            if(yF > yT)
            {
                return 2;
            }
            else
            {
                return 1;
            }
        }
        else
        {
            mcInst.ingameGUI.addChatMessage("Error: Marker must be in line with the origin.");
            resetSelectors(world);
            return 0;
        }
    }

    public static void initImport(World world, EntityPlayer entityplayer)
    {
        if(xDirect == yDirect || xDirect == 0 || yDirect == 0)
        {
            mcInst.ingameGUI.addChatMessage("Error: Selection must be a flat plane.");
            resetSelectors(world);
            return;
        }

        try
        {
            BufferedImage bufferedimage = ImageIO.read(importPath);
            importInstance = new WandImageImportStandard(entityplayer, world, xF, yF, zF, xEnd, yEnd, bufferedimage, xDirect, yDirect);
            importing = false;
            importInProgress = true;
            resetSelectors(world);
            mcInst.ingameGUI.addChatMessage("Import initialized. Please keep the game open while the importer works.");
        }
        catch(IOException ioexception)
        {
            mcInst.ingameGUI.addChatMessage("Error: The system cannot find the file specified.");
            resetSelectors(world);
            importing = false;
        }
    }

    public static void resetSelectors(World world)
    {
        resetFirstSelector(world);
        resetSecondSelector(world);
        resetThirdSelector(world);
    }

    public static void resetFirstSelector(World world)
    {
        if(firstset){
            int meta1 = world.getBlockMetadata(xF, yF, zF);
            if(fID != coloredblockid)
            {
                world.setBlockAndMetadata(xF, yF, zF, fID, meta1);
            }
            if(fID == coloredblockid)
            {
                TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(xF, yF, zF);
                if(tile != null)
                {
                    tile.setRed(fRed);
                    tile.setGreen(fGreen);
                    tile.setBlue(fBlue);
                }
            }
            world.markBlockNeedsUpdate(xF, yF, zF);
            firstset = false;
        }
    }

    public static void resetSecondSelector(World world)
    {
        if(secondset){
            int meta2 = world.getBlockMetadata(xS, yS, zS);
            if(sID != coloredblockid)
            {
                world.setBlockAndMetadata(xS, yS, zS, sID, meta2);
            }
            if(sID == coloredblockid)
            {
                TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(xS, yS, zS);
                if(tile != null)
                {
                    tile.setRed(sRed);
                    tile.setGreen(sGreen);
                    tile.setBlue(sBlue);
                }
            }
            world.markBlockNeedsUpdate(xS, yS, zS);
            secondset = false;
        }
    }

    public static void resetThirdSelector(World world)
    {
        if(thirdset){
            int meta3 = world.getBlockMetadata(xT, yT, zT);
            if(tID != coloredblockid)
            {
                world.setBlockAndMetadata(xT, yT, zT, tID, meta3);
            }
            if(tID == coloredblockid)
            {
                TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(xT, yT, zT);
                if(tile != null)
                {
                    tile.setRed(tRed);
                    tile.setGreen(tGreen);
                    tile.setBlue(tBlue);
                }
            }
            world.markBlockNeedsUpdate(xT, yT, zT);
            secondset = false;
        }
    }

    public static int redVal = 0xff;
    public static int blueVal = 0xff;
    public static int greenVal = 0xff;

    public static boolean importing = false;
    public static boolean importInProgress = false;
    public static File importPath = null;
    public static boolean firstset = false;
    public static boolean secondset = false;
    public static boolean thirdset = false;
    public static int xEnd = 0;
    public static int yEnd = 0;
    public static int xF = 0;
    public static int yF = 0;
    public static int zF = 0;
    public static int xS = 0;
    public static int yS = 0;
    public static int zS = 0;
    public static int xT = 0;
    public static int yT = 0;
    public static int zT = 0;
    public static int fID = 0;
    public static int sID = 0;
    public static int tID = 0;
    public static int fRed = 0;
    public static int fGreen = 0;
    public static int fBlue = 0;
    public static int sRed = 0;
    public static int sGreen = 0;
    public static int sBlue = 0;
    public static int tRed = 0;
    public static int tGreen = 0;
    public static int tBlue = 0;
    public static int xDirect = 0;
    public static int yDirect = 0;
    public static WandImageImportStandard importInstance = null;
    public long importtimer;

    public static World theWorld;
    public static long importDelay = 16L;
    public static final Block coloredblock;
    public static final Item coloringwand;
    public static mod_ColoredBlocks instance;
    public static int coloredblockid = 211;
    public static int wandid = 15000;
    public static int itemindex1;
    public static Minecraft mcInst = ModLoader.getMinecraftInstance();
    public static final File propsFile = new File(Minecraft.getMinecraftDir(), "/mods/peronix/ColoredBlocks/ColoredBlocks.properties");
    public static final File imageDir = new File(Minecraft.getMinecraftDir(), "/mods/peronix/ColoredBlocks/images/");
    static 
    {
        RegisterTextures();
        LoadProperties();
        coloredblock = (new BlockColored(coloredblockid)).setHardness(1.5F).setResistance(10F).setBlockName("blockColored");
        coloringwand = (new ItemWand(wandid)).setIconIndex(itemindex1).setItemName("importWand");
        RegisterNames();
        RegisterBlocks();
    }
}